;=======================================================================;
;==================== List processing include code =====================;
; 07/13/1998 TAH - Modify list processing for Synergy V6

	;	Perform a request from L_PROCESS
list_request,
	case req of
	  begincase
	    nop				; D_LLOADBOT
	    nop				; D_LLOADTOP
	    g_select = TRUE		; D_LABORT
	  endcase
	return

	;	process the input window
list_input,
	if (list_check.eq.ut_blanks)
	 then xcall i_init (inpid,list_iset,list_record)
	 else
	  begin
	    xcall i_display (inpid,list_iset,list_record)
	    if (fldnam)
	     then xcall i_next (inpid,list_iset,fldnam)
	     else xcall i_next (inpid,list_iset,'*FRST*')
	  end

	do begin
          call list_linput
	  if (g_select) then
	    begin
	      fldnam = g_fldnam
	      case g_entnam of
		begincase
		"END":	  begin
			    g_select = TRUE
			    return
			  end
		"ABORT":  begin
			    req = D_LRESTORE
			    clear g_select
			    return
			  end
		"DELETE": begin
			    if (list_check)
			      begin
				opcde = TRUE
				if (ut_delete.eq.'Y') xcall confirm (opcde,2)
				if (opcde.eq.TRUE)
				  begin
				    req = D_LDELITEM
				    call list_delete
;;*DEL*;;			    if (opcde.eq.TRUE) return
				  end
				if (req.eq.D_LDELITEM) clear g_setsts,g_select
			      end
			  end
		"FIND":   call find_process
		"MAINT":  call maint_process
		"M_":     call menu_process
		"O_":	  begin
			    call list_function
			    clear g_setsts,g_select
			    return
			  end
		endcase
	       else call select_processing
	    end
	   else
	    begin
	      if (g_setsts)
		begin
		  fldnam = g_fldnam
		  call setsts_processing
		end
	    end
	end until (.not.g_setsts) .and. (.not.g_select)
	
	if (list_check) call list_advance
	fldnam = "*FRST*"
	return

	;	request an advance to next record on the list
list_advance,
	xcall l_status (lstid, D_LATBOTTOM, atend)
	if (atend) .and. (list_check)
	 then req = D_LAPPEND
	 else req = D_LDOWN
	return

	;	determine function key request
list_function,
	case g_entnam of
	  begincase
	  "O_CANCEL":	req = D_LCANCEL
	  "O_TOP":	req = D_LTOP
	  "O_BOTTOM":	req = D_LBOTTOM
	  "O_PGUP":	req = D_LPGUP
	  "O_PGDN":	req = D_LPGDN
	  "O_PGTOP":	req = D_LPGTOP
	  "O_PGBOT":	req = D_LPGBOT
	  "O_UP":	req = D_LUP
	  "O_DOWN":	call list_advance
	  "O_LEFT":	req = D_LLEFT
	  "O_RIGHT":	req = D_LRIGHT
	  "O_INSERT":	begin
			  req = D_LINSERT
			  call list_insert
			end
	  "O_FIND":	begin
			  call list_find
			  clear g_select
			end
	  endcase
	return

	;
list_find,
	xcall u_message ('At find')
	return

;========================= End of include code =========================;
