 
;  SYNERGY DATA LANGUAGE OUTPUT
;
;  REPOSITORY     : RPSDAT:rpsmain.ism
;                 : RPSDAT:rpstext.ism
;                 : Version 7.1.5
;
;  GENERATED      : 22-JAN-2001, 17:05:34
;                 : Version 7.1.5
;  EXPORT OPTIONS : [ALL] 
 
 
Structure NAMAST   DBL ISAM
   Description "Name and address"
 
Format TELEPHONE   Type ALPHA   "(@@@)@@@-@@@@/@@@@"
 
Format FAX   Type ALPHA   "(@@@)@@@-@@@@"
 
Field NAM_KEY   Type ALPHA   Size 10
   Description "Primary Key"
 
Field NAM_COMP   Type ALPHA   Size 2   Overlay NAM_KEY:0
   Description "Company code"
 
Field NAM_ID   Type DECIMAL   Size 8   Overlay NAM_KEY:2
   Description "Name ID"
 
Field NAM_SORT   Type ALPHA   Size 10
   Description "Sort name"
   Uppercase
   Change Method "NAM_SORT_CHANGE"
 
Field NAM_NAME   Type ALPHA   Size 30
   Description "Name"
   Required
   Change Method "NAM_NAME_CHANGE"
 
Field NAM_ADDR1   Type ALPHA   Size 30
   Description "Address line 1"
   Change Method "NAM_ADDR_CHANGE"
 
Field NAM_ADDR2   Type ALPHA   Size 30
   Description "Address line 2"
   Change Method "NAM_ADDR_CHANGE"
 
Field NAM_ADDR3   Type ALPHA   Size 32
   Description "Address line 3"
 
Field NAM_STATE   Type ALPHA   Size 2   Overlay NAM_ADDR3:0
   Description "State code"
   Uppercase
   Required
 
Field NAM_CITY   Type ALPHA   Size 20   Overlay NAM_ADDR3:2
   Description "City name"
   Change Method "NAM_CITY_CHANGE"
 
Field NAM_ZIP   Type ALPHA   Size 10   Overlay NAM_ADDR3:22
   Description "Zip code"
   Required
 
Field NAM_PHONE   Type ALPHA   Size 14
   Description "Telephone"
   Format TELEPHONE
 
Field NAM_FAX   Type ALPHA   Size 10
   Description "Fax number"
   Format FAX
 
Field NAM_STATUS   Type ALPHA   Size 1
   Description "Status code"
   Uppercase
   Selection List 0 0 0  Entries "Active", "Inactive", "Temporary",
         "Bad Address"
 
Field NAM_PARENT   Type DECIMAL   Size 8
   Description "Parent ID"
 
Field NAM_TYPE   Type ALPHA   Size 1   Dimension 6
   Description "Name types"
   Selection Window 0 0 "NOYES"
   Change Method "ANYFLD_CHANGE"
 
Field NAM_BFLDR   Type DECIMAL   Size 2
   Description "Base contact folder"
 
Field NAM_GEOGCODE   Type ALPHA   Size 3
   Description "Geographic location code"
   User Text "#Drill/Opt/N#"
   Drill Method "SMCODE_FIND"   Hyperlink Method "SMCODE_HYPER"
 
Field NAM_OPER   Type ALPHA   Size 12
   Description "Operator name"
 
Field NAM_HOURS   Type DECIMAL   Size 2
   Description "Number of hours away"
   Negative
   Range -24 24
 
Field NAM_CREATED   Type DATE   Size 8   Stored YYYYMMDD
   Description "Date created"
   Date Today
 
Field NAM_CHANGED   Type DATE   Size 8   Stored YYYYMMDD
   Description "Date changed"
 
Field NAM_MODIFIED   Type ALPHA   Size 1
   Description "Modified flag"
 
Field NAM_OLDID   Type ALPHA   Size 6
   Description "Old ID"
 
Field NAM_OLDPARENT   Type ALPHA   Size 6
   Description "Old parent ID"
 
Field NAM_USERID   Type ALPHA   Size 3
   Description "User ID"
 
Field NAM_DELPOINT   Type ALPHA   Size 3
   Description "Delivery point"
 
Field NAM_CART   Type ALPHA   Size 4
   Description "Carrier route"
 
Field NAM_ADDERROR   Type ALPHA   Size 1
   Description "Address checked/error"
 
Key PRIMARY   ACCESS   Order ASCENDING   Dups NO   Compress INDEX RECORD
   Description "Primary key"
   Segment FIELD   NAM_COMP
   Segment FIELD   NAM_ID
 
Key SORT   ACCESS   Order ASCENDING   Dups YES   Modifiable YES
   Compress INDEX   Krf 001
   Description "Sort name"
   Segment FIELD   NAM_SORT
 
Key ZIPCODE   ACCESS   Order ASCENDING   Dups YES   Modifiable YES   Krf 002
   Description "Zip code"
   Segment FIELD   NAM_ZIP
   Segment FIELD   NAM_ID
 
Key PHONE   ACCESS   Order ASCENDING   Dups YES   Modifiable YES   Krf 003
   Description "Telephone"
   Segment FIELD   NAM_PHONE
 
Key CITY   ACCESS   Order ASCENDING   Dups YES   Modifiable YES   Krf 004
   Description "City"
   Segment FIELD   NAM_CITY
 
Key PARENT   ACCESS   Order ASCENDING   Dups YES   Modifiable YES   Krf 005
   Description "Parent ID"
   Segment FIELD   NAM_PARENT
   Segment FIELD   NAM_COMP
   Segment FIELD   NAM_ID
 
Key OLDID   ACCESS   Order ASCENDING   Dups YES   Modifiable YES   Krf 006
   Description "Old Name ID"
   Segment FIELD   NAM_OLDID
 
File NAMAST   DBL ISAM   "FIL:namast.ism"
   Description "Name and Address"
   Density 50
 
