
.script
;
;=======================================================================
.column inmiscmenu, "Miscellaneous", select(z)
.entry z_purp, "Purge expired pricing"
.entry z_purh, "Purge history"
.line
.entry z_rank, "Item ranking by sales"
.entry z_wchk, "Warehouse check list"
.entry z_padj, "Adjust prices"
.entry z_copy, "Copy items from/to locations"
.entry z_dell, "Delete items from location"
.entry z_rkit, "Recalculate kit costs"
.entry z_chgi, "Change item ID"
.entry z_impt, "Import ascii file to items"
.entry z_cycl, "Assign cycle count codes"
.entry z_updc, "Import/Update costs"
.end
;
;===============================================================
.input in8750, 10, 76
.placement 1, 1
.title ' Import/Update Costs ', highlight
.paint _

.field comp, a2, pos(1,1), prompt("Company code"), fpos(1,20)

.field filename, a40, pos(2,1), prompt("File name"), fpos(2,20)

.field costs, a1, pos(3,1), prompt("Cost to update"), fpos(3,20), -
select(1,3,,"Standard cost","Average cost","Last cost")

.field option, a1, pos(4,1), prompt("List or Update"), fpos(4,20), -
select(1,3,,"List","Update")

.text Text1, pos(5,1)
=============================================================================
.text Text2, pos(6,1)
  Each record in the 36 character, fixed length file is required as follows:
.text Text3, pos (7,1)
   * The first 24 characters/spaces as the item ID
.text Text4, pos (8,1)
   * The next 3 characters/spaces as the location code
.text Text5, pos (9,1)
   * The last 9 digits as the new cost-must be numeric, with leading zeros,
.text Text6, pos (10,1)
      including 3 decimal places, no decimal point (ie 000042325=42.325)

.structure rec1, comp, filename, costs, option
.set set1, rec1, comp, filename, costs, option
.end
;
;===============================================================
