;==File=================================================================;
; GL6900.DBL
;=======================================================================;
; Copyright 1999 by TAH Software Systems (TAH), Oklahoma City, Oklahoma ;
;									;
;	TAH provides this software under a license and may only be	;
;	used in accordance with the terms and conditions of such	;
;	license and with the inclusion of the above Copyright notice.	;
;==Function=============================================================;
;	gl6900		Transaction audit report.
;==Changes==============================================================;
;=======================================================================;
.subroutine gl6900


.start nopage,nolist
.include "UTL:tools.def"
.include "UTS:dteut.def"
.include "GLS:dtegl.def"


.include "UTS:utcomm.gbl"
.include "GLS:glcomm.gbl"
.include "GLS:glyear.rec"
.include "GLS:glsubl.rec"
.include "APS:apcomm.gbl"
.include "APS:aphist.rec"
.include "ARS:arcomm.gbl"
.include "ARS:arhist.rec"


external function
	smctrl		,a


record	head1
		,a*	@4,	'TAG ID'
		,a*	@19,	'CO'
		,a*	@23,	'ACCT'
		,a*	@29,	'DIV'
		,a*	@34,	'DEPT'
		,a*	@40,	'REFER'
		,a*	@51,	'DATE'
		,a*	@59,	'JRNL'
		,a*	@65,	'DESCRIPTION'
		,a*	@91,	'C/V-NO'
		,a*	@98,	'INV/CHK'
		,a*	@107,	'COST-CENTER'
		,a*	@126,	'AMOUNT'
record	head2					; Accounts Payable
		,a*	@19,	'CO'
		,a*	@22,	'VENDOR'
		,a*	@29,	'VOUCHR'
		,a*	@36,	'INVOICE'
		,a*	@46,	'INVC-DATE'
		,a*	@56,	'TYPE'
		,a*	@72,	'PO-NO'
		,a*	@79,	'DIST-DATE'
		,a*	@89,	'CHECK-DATE'
		,a*	@100,	'CHK-NO'
		,a*	@107,	'COST-CENTER'
		,a*	@126,	'AMOUNT'
record	head3					; Accounts Receivable
		,a*	@19,	'CO'
		,a*	@22,	'CUSTMR'
		,a*	@29,	'APPLY-TO'
		,a*	@38,	'REFER-NO'
		,a*	@48,	'INVC-DATE'
		,a*	@58,	'TYPE'
		,a*	@71,	'ORD-NO'
		,a*	@86,	'FREIGHT'
		,a*	@97,	'TAX/DISC'
		,a*	@107,	'COST-CENTER'
		,a*	@126,	'AMOUNT'


record	legnd1
		,a8	@1,	'COMPANY:'
	lcompy	,a2	@10


record	pline
		,a132
record	,X
	prtagid		,a14	@1
	prfile		,a10	@8
	prcomp		,a2	@19
	prj_acct	,a6	@22		; Journal Voucher
	prj_div		,a4	@29
	prj_dept	,a4	@34
	prj_ref		,a8	@39
	prj_date	,a10	@48
	prj_jrnl	,a2	@60
	prj_desc	,a25	@65
	prj_cust	,a6	@91
	prj_invc	,a8	@98
	prj_catg	,a3	@107
	prj_cost	,a6	@111
	prj_amnt	,a15	@118
record	,X					; Accounts Payable
	prp_vend	,a6	@22
	prp_voch	,a6	@29
	prp_invc	,a8	@36
	prp_idate	,a10	@45
	prp_type	,a10	@56
	prp_pono	,a6	@71
	prp_ddate	,a10	@78
	prp_cdate	,a10	@89
	prp_chkno	,a6	@100
	prp_catg	,a3	@107
	prp_cost	,a6	@111
	prp_amount	,a15	@118
record	,X					; Accounts Receivable
	prr_cust	,a6	@22
	prr_aply	,a8	@29
	prr_refer	,a8	@38
	prr_idate	,a10	@47
	prr_type	,a10	@58
	prr_order	,a6	@71
	prr_freight	,a11	@83
	prr_tax_disc	,a11	@95
	prr_catg	,a3	@107
	prr_cost	,a6	@111
	prr_amount	,a15	@118


record	totals
	gltotal		,d11.2		; G/L  total
	artotal		,d11.2		; A/R total
	aptotal		,d11.2		; A/P total


record	scr_rec1		; input set 1
	scr_acct	,a6		; account
	scr_div		,a4		; division
	scr_dept	,a4		; department
	scr_ref		,a8		; reference


record
	abort		,d1
	eof		,d1		; end of file switch
	glyear_lchan	,d2		; local channel for glyear open
	lstact		,a16		; last account
	mask		,a15,	'ZZZ,ZZZ,ZZZ.XX-'
	recs_read	,d6
	title		,a*,	'TRANSACTION AUDIT'
	wdone		,d1
	wind_name	,a*,	'gl6900'
	wind_no		,d2		; input window id
	wind_signal	,a31
.start nopage,list


.proc
	;>>>>>	Main processing  <<<<<;
	call do_setup
	call open_files
	call get_parameters
	if (abort.eq.FALSE)
	  begin
	    call get_destination
	    if (abort.eq.FALSE)
	      begin
		call print_report
		call print_report_totals
		xcall clslp ('Transaction Audit Report')
	      end
	  end
	call close_files
	call do_shutdown
	xreturn		; to calling program


	;>>>>>	End of main processing  <<<<<;


	;	Set up environment
do_setup,
	xcall e_enter
	xcall lodcol ('RL')		; remove local columns
	xcall lodtoolbar ('AB',8)
	return


	;	Shut down environment
do_shutdown,
	xcall lodtoolbar ('RB',8)
	xcall e_exit
	return


	;	Open the needed data files
open_files,
	xcall open (glchrt_chan,'I:I',glchrt_name)
	xcall open (glyear_chan,'I:I',glyear_name)
	xcall open (glyear_lchan,'I:I',glyear_name,DTE_LOCAL)
	xcall open (glsubl_chan,'I:I',glsubl_name)
	xcall open (gltabl_chan,'I:I',gltabl_name)
	if (%smctrl(ut_cmcomp,'AP','APHIST'))
	    xcall open (aphist_chan,'I:I',aphist_name)
	if (%smctrl(ut_cmcomp,'AR','ARHIST'))
	    xcall open (arhist_chan,'I:I',arhist_name)
	return


	;	Close the data files opened for the report
close_files,
	xcall close (glchrt_chan,DTE_CLOSE)
	xcall close (glyear_chan,DTE_CLOSE)
	xcall close (glyear_lchan,DTE_CLOSE)
	xcall close (glsubl_chan,DTE_CLOSE)
	xcall close (gltabl_chan,DTE_CLOSE)
	if (aphist_chan) xcall close (aphist_chan,DTE_CLOSE)
	if (arhist_chan) xcall close (arhist_chan,DTE_CLOSE)
	return


	;	Get the report selection parameters
get_parameters,
	repeat
	  begin
	    xcall get_parameters (wind_no,wind_name,'set1',scr_rec1,abort,wind_signal)
	    if (abort.eq.TRUE) exitloop
	    if (wind_signal)
	     then call process_signal
	     else
	      begin
		call verify_input_parameters
		if (wdone.eq.TRUE) exitloop
	      end
	  end
	return


	;	Process any break signals
process_signal,
	case g_entnam of
	  begincase
	  '@': nop
	  endcase
	return


verify_input_parameters,
	wdone = TRUE
	return


	;	Get the output destination
get_destination,
	abort = FALSE
	lcompy = ut_cmcomp
	clear lp_sel
	xcall askpr (ut_cmname,132,61,0,ut_cmdefp)
	if (lp_sel.eq.'E') abort = TRUE
	return


	;	Print the report
print_report,
	xcall status (DTEM_PRT)
	clear recs_read
	xcall statusbar (0,glyear_chan)


	gly_comp = ut_cmcomp
	gly_acct = scr_acct
	gly_div  = scr_div
	gly_dept = scr_dept
	gly_ref  = scr_ref
	xcall db_find (glyear_chan,gly_key,0,'M',,,opcde)


	repeat
	  begin
	    clear totals
	    xcall db_next (glyear_chan,glyear,'F','M',,,opcde)
	    if (opcde) .or.
	    &  (gly_comp.ne.ut_cmcomp) .or.
	    &  (gly_acct.ne.scr_acct) .or.
	    &  (gly_div.ne.scr_div) .or.
	    &  (gly_dept.ne.scr_dept) .or.
	    &  (gly_ref.ne.scr_ref) return
	    incr recs_read
	    if (.not.recs_read(5:2)) xcall statusbar (recs_read)


	    prtagid = gly_tag_id
	    call print_glyear
	    ut_dummy = glyear
	    eof = FALSE


	    xcall db_find (glsubl_chan,gly_tag_id,2,'M',,,opcde)
	    if (opcde) then
	      begin
	        gll_tag_orig = gly_tag_id
		call check_glyear
		if (aphist_chan) call print_aphist
		if (arhist_chan) call print_arhist
	      end
	     else
	      do begin
		  call print_glsubl
		  if (eof.eq.FALSE)
		    begin
		      call check_glyear
		      ut_dummy(1:2) = ut_cmcomp
		      if (aphist_chan) call print_aphist
		      if (arhist_chan) call print_arhist
		    end
	         end until (eof.eq.TRUE)
	    prj_desc = 'GL SUBLEDGER TOTAL'
	    prj_amnt = gltotal, mask
	    call print
	    call print
	  end


	;	Print the report totals
print_report_totals,
	return


	;	print GLYEAR record
print_glyear,
	prcomp = gly_comp
	prj_acct = gly_acct
	prj_div = gly_div
	prj_dept = gly_dept
	prj_ref = gly_ref
	xcall dtdsp (gly_date,prj_date)
	prj_jrnl = gly_jrnl
	prj_desc = gly_desc
	prj_cust = gly_cust_vend
	prj_invc = gly_invc_chek
	prj_catg = gly_catg
	prj_cost = gly_cost
	prj_amnt = gly_amnt, mask
	call print
	return


	;	look for GLYEAR records with original tag id
check_glyear,
	xcall db_read (glyear_lchan,,gll_tag_orig,2,'M',,,opcde)
	if (opcde) return
	do forever

	  begin
	    xcall db_next (glyear_lchan,glyear,'F','M',,,opcde)
	    if (opcde) .or.
	    &  (gly_tag_id.ne.gll_tag_orig) return
	    if (glyear.ne.ut_dummy) then
	      begin
		prfile = '  (GLYEAR)'
		call print_glyear
	      end
	     else clear ut_dummy(1:2)
	  end


	;	find matching subledger tag id
print_glsubl,
	do forever
	  begin
	    xcall db_next (glsubl_chan,glsubl,'F','M',,,opcde)
	    if (opcde) .or.
	    &  (gll_comp.ne.ut_cmcomp) .or.
	    &  (gll_acct.ne.scr_acct) .or.

	    &  (gll_div.ne.scr_div) .or.
	    &  (gll_dept.ne.scr_dept) .or.
	    &  (gll_ref.ne.scr_ref)
	      begin
		eof = TRUE
		return
	      end
	
	    prtagid = '--------------'
	    call print
	    prfile = '(GLSUBL)'
	    prcomp = gll_comp
	    prj_acct = gll_acct
	    prj_div = gll_div
	    prj_dept = gll_dept
	    prj_ref = gll_ref
	    xcall dtdsp (gll_date,prj_date)
	    prj_jrnl = gll_ledger
	    prj_desc = gll_desc
	    prj_cust = gll_cust_vend
	    prj_invc = gll_invc_chek
	    prj_catg = gll_catg
	    prj_cost = gll_cost
	    prj_amnt = gll_amnt, mask
	    call print
	    gltotal = gltotal + gll_amnt
	    return
	  end


	;	find matching APHIST tag id
print_aphist,
	clear aptotal
	xcall db_find (aphist_chan,gll_tag_orig,2,'M',,,opcde)
	if (opcde) return
	call print
	pline = head2		; print header for AP
	call print
	call print
	do forever
	  begin
	    xcall db_next (aphist_chan,aphist,'F','M',,,opcde)
	    if (opcde) .or.
	    &  (aph_tag_id.ne.gll_tag_orig)
	      begin
		prj_desc = 'AP TRANSACTION TOTAL'
		prj_amnt = aptotal, mask
		call print
		call print
		return
	      end
	
	    prfile = '  (APHIST)'
	    prcomp = aph_comp
	    prp_vend = aph_vend
	    prp_voch = aph_vch, 'XXXXXX'
	    prp_invc = aph_inno
	    xcall dtdsp (aph_indt,prp_idate)
	    case aph_type of
	      begincase
		prp_type = 'Invoice'	; 1
		prp_type = 'Prepaid'	; 2
		prp_type = 'DR memo'	; 3
		prp_type = 'Check'	; 4
		prp_type = '???'	; 5
		prp_type = '???'	; 6
		prp_type = '???'	; 7
		prp_type = '???'	; 8
		prp_type = 'Void'	; 9
	      endcase
	    prp_pono = aph_pono, 'ZZZZZZ'
	    xcall dtdsp (aph_dist,prp_ddate)
	    xcall dtdsp (aph_ckdt,prp_cdate)
	    prp_chkno = aph_ckno, 'ZZZZZZ'
	    prp_catg = aph_catg
	    prp_cost = aph_cost
	    case aph_type of
	      begincase
		begin				; 1
		  prp_amount = aph_amnt, mask
		  aptotal = aptotal + aph_amnt
		end
		begin				; 2
		  prp_amount = aph_amnt, mask
		  aptotal = aptotal + aph_amnt
		end

		begin				; 3
		  prp_amount = -aph_amnt, mask
		  aptotal = aptotal - aph_amnt
		end
		begin				; 4
		  prp_amount = -aph_amnt, mask
		  aptotal = aptotal - aph_amnt
		end
		nop				; 5
		nop				; 6
		nop				; 7
		nop				; 8
		begin				; 9
		  prp_amount = aph_amnt, mask
		  aptotal = aptotal + aph_amnt
		end
	      endcase
	    call print
	  end


	;	find matching ARHIST tag id
print_arhist,
	clear artotal
	xcall db_find (arhist_chan,gll_tag_orig,2,'M',,,opcde)
	if (opcde) return
	call print
	pline = head3		; print header for AR
	call print
	call print
	do forever
	  begin
	    xcall db_next (arhist_chan,arhist,'F','M',,,opcde)
	    if (opcde) .or.
	    &  (arh_tag_id.ne.gll_tag_orig)
	      begin
		prj_desc = 'AR TRANSACTION TOTAL'
		prj_amnt = artotal, mask
		call print
		call print
		return
	      end
	
	    prfile = '  (ARHIST)'
	    prcomp = arh_comp
	    prr_cust = arh_cust
	    prr_aply = arh_aply
	    prr_refer = arh_ref
	    xcall dtdsp (arh_date,prr_idate)
	    case arh_type of
	      begincase
		prr_type = 'Invoice'	; 1
		prr_type = 'Payment'	; 2
		prr_type = 'CR memo'	; 3
		prr_type = 'DR memo'	; 4
		prr_type = 'Fin Chg'	; 5
		prr_type = 'Wrt Off'	; 6
		prr_type = '???'	; 7
		prr_type = '???'	; 8
		prr_type = '???'	; 9
	      endcase
	    prr_order = arh_orno
	    prr_freight = arh_frta, mask
	    prr_tax_disc = arh_othr, mask
	    prr_catg = arh_catg
	    prr_cost = arh_cost
	    case arh_type of
	      begincase
		begin				; 1
		  prr_amount = arh_amnt, mask
		  artotal = artotal + arh_amnt
		end
		begin				; 2
		  prr_amount = -arh_amnt, mask
		  artotal = artotal - arh_amnt
		end
		begin				; 3
		  prr_amount = -arh_amnt, mask
		  artotal = artotal - arh_amnt
		end
		begin				; 4
		  prr_amount = arh_amnt, mask
		  artotal = artotal + arh_amnt
		end
		begin				; 5
		  prr_amount = arh_amnt, mask
		  artotal = artotal + arh_amnt
		end
		begin				; 6
		  prr_amount = -arh_amnt, mask
		  artotal = artotal - arh_amnt
		end
		nop				; 7
		nop				; 8
		nop				; 9
	      endcase
	    call print
	  end


	;	Print a detail line of the report
print,
	xcall print (pline,title,head1,,,legnd1)
	clear pline
	if (lp_cnt.eq.-1)
	  begin
	    call close_files
	    call do_shutdown
	    xreturn		; to calling program
	  end
	return
.end


