;==File=================================================================;
; APIVHST.DBL
;=======================================================================;
; Copyright 1999 by TAH Software Systems (TAH), Oklahoma City, Oklahoma ;
;									;
;	TAH provides this software under a license and may only be	;
;	used in accordance with the terms and conditions of such	;
;	license and with the inclusion of the above Copyright notice.	;
;==Function=============================================================;
;	ap_inq_vhst	Vendor summary history search routine.
;	apll_apvhst	Load List with vendor history information
;==Changes==============================================================;
; 07/13/1998 tah - Modify list processing for Synergy V6
; 02/09/1998 tah - New program.
;=======================================================================;
.subroutine ap_inq_vhst

	a_apvhst	,a	; I/O - Record to return
	a_key		,a	; IN  - Key value for begin of search

.start nopage,nolist
.include "WND:tools.def"
.include "WND:system.def"
.include "WND:inpctl.def"
.include "UTS:dteut.def"
.include "APS:dteap.def"

.include "UTS:utcomm.gbl"
.include "APS:apcomm.gbl"
.include "APS:apvhst.rec"

global data section list_apvhst, init
record
	c_apvhst_pos	,d4		; key position
	c_apvhst_chan	,d3		; file open channel
	c_apvhst_dtype	,d1		; display line type
	c_apvhst_keystr	,a20		; key value for start
record	sel_line
	sel_year	,d4
	sel_type	,a3
	sel_vch		,[12]d4
	sel_pur		,[12]d9.2
endglobal

.align
record
	colid		,i4		; column id
	fndid		,i4		; find id
	inpid		,i4		; input column id
	selid		,i4		; selection column id
	req		,i4
	srch		,i4		; search parameter
	field_no	,d3		; field number from i_fldinf
	lfind		,a*,	'i_lxxxxxx'
	  lfind_file	,a6	@lfind+3
        lclass          ,a*,    'l_xxxxxx'
          lclass_file   ,a6     @lclass+2
	wind_header	,a160		; window header from script
	  wind_hleft	,a80	@wind_header
	  wind_hright	,a80	@wind_header+80
.start nopage,list

.proc
	lfind_file = 'apvhst'
        lclass_file = lfind_file
	if (a_key.eq.ut_blanks) xreturn		; return if no key value

	c_apvhst_pos = %trim(a_key)			; set global variables
	c_apvhst_chan = apvhst_chan
	clear c_apvhst_dtype
	c_apvhst_keystr = a_key

.include "UTS:utfind.inc"

	if (g_entnam.eq.'O_EXIT')
	 then clear a_apvhst
	 else
	  begin
	    apvh_key = a_key
	    apvh_year = sel_year
	    a_apvhst = apvhst
	  end
	xcall e_exit
	xreturn		; to calling program

find_first_match,
	xcall db_find (apvhst_chan,a_key(1:c_apvhst_pos),0,'M',,,opcde)
	case opcde of
	  begincase
	  1: xcall message (DTER_RNF)
	  2: xcall message (DTER_LOK)
	  endcase
	return

utfind_find,
	return
.end
;=======================================================================;
.subroutine apll_apvhst

	a_listid	,n	; IN  - Window id for list
	a_request	,n	; IN  -
	a_data		,a	; I/O - Data record area
	a_inpid		,n	; IN  -
	a_disabled	,n	; IN  -
	a_index		,n	; IN  -

.start nopage,nolist
.include "UTS:utcomm.gbl"

.include "APS:apvhst.rec"

global data section list_apvhst
record
	c_apvhst_pos	,d4		; key position
	c_apvhst_chan	,d3		; file open channel
	c_apvhst_dtype	,d1		; display line type
	c_apvhst_keystr	,a20		; key value for start
record	sel_line
	sel_year	,d4
	sel_type	,a3
	sel_vch		,[12]d4
	sel_pur		,[12]d9.2
endglobal

record
	ndx		,d2		; loop control
.start nopage,list

.proc
	if (c_apvhst_dtype.eq.0) then
	  begin
	    call get_record
	    c_apvhst_dtype = 1
	  end
	 else
	  begin
	    call disp_pur
	    clear c_apvhst_dtype
	  end
	xreturn

disp_pur,
	sel_year = apvh_year
	sel_type = 'Pur'
	for ndx from 1 thru 12
	  sel_pur[ndx] = apvh_ypur[ndx]
	xcall i_display (a_inpid,'set2',sel_line)
	return

get_record,
	xcall db_next (c_apvhst_chan,apvhst,'F','M',,,opcde)
	unlock c_apvhst_chan
	case opcde of
	  begincase
	  1: a_request = D_LEOF
          2: a_request = D_LEOF
	  endcase
	 else
	  if (apvh_key.eq.c_apvhst_keystr(1:c_apvhst_pos)) then
	    begin
	      clear sel_line
	      sel_year = apvh_year
	      sel_type = 'Vch'
	      for ndx from 1 thru 12
		sel_vch[ndx] = apvh_yvch[ndx]
	      xcall i_display (a_inpid,'set1',sel_line)
	      a_data = sel_line
	    end
	   else a_request = D_LEOF
	return
.end
;=======================================================================;

